<?php
/* Template Name: Register */
get_header();
?>

<h2>Create Account</h2>

<form method="post">
    <input type="text" name="username" placeholder="Username" required>
    <input type="email" name="email" placeholder="Email" required>
    <input type="password" name="password" placeholder="Password" required>
    <button type="submit" name="register_user">Register</button>
</form>

<?php
if (isset($_POST['register_user'])) {
    $username = sanitize_user($_POST['username']);
    $email = sanitize_email($_POST['email']);
    $password = $_POST['password'];

    $user_id = wp_create_user($username, $password, $email);

    if (!is_wp_error($user_id)) {
        echo "<p>Registration successful. You can now log in.</p>";
    } else {
        echo "<p>Error: " . $user_id->get_error_message() . "</p>";
    }
}

get_footer();
